﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using DataAccess;

/// <summary>
/// Summary description for CPatientDataItem
/// </summary>
public class CPatientDataItemXfer
{
    public string PatientID { get; set; }
    public string FirstName { get; set; }
    public string FullName { get; set; }
    public string MI { get; set; }
    public string LastName { get; set; }
    public string SSN { get; set; }
    public string SSNLast4 { get; set; }
    public DateTime DOB { get; set; }
    public k_SEX Sex { get; set; }
    public string SexLabel { get; set; }
    public string SexAbbreviation { get; set; }
    public long Age { get; set; }

    public string HomeCity { get; set; }
    public string HomeState { get; set; }
    public string HomeAddr1 { get; set; }
    public string HomeAddr2 { get; set; }
    public string HomeZipCode { get; set; }

    public string HomePhone { get; set; }

    public CPatientDataItemXfer()
	{

    }

    public CPatientDataItemXfer(DataSet ds)
    {

        if(!CDataUtils2.IsEmpty(ds))
        {
            PatientID = CDataUtils2.GetDSStringValue(ds, "PATIENT_ID");
            FirstName = CDataUtils2.GetDSStringValue(ds, "FIRST_NAME");
            MI = CDataUtils2.GetDSStringValue(ds, "MIDDLE_INITIAL");
            LastName = CDataUtils2.GetDSStringValue(ds, "LAST_NAME");
            SSN = CDataUtils2.GetDSStringValue(ds, "SSN");
            DOB = CDataUtils2.GetDSDateTimeValue(ds, "DATE_OF_BIRTH");
            Sex = (k_SEX)CDataUtils2.GetDSLongValue(ds, "SEX_ID");
            SexLabel = CDataUtils2.GetDSStringValue(ds, "SEX_LABEL");
            SexAbbreviation = CDataUtils2.GetDSStringValue(ds, "SEX_ABBREVIATION");
            SSNLast4 = CDataUtils2.GetDSStringValue(ds, "SSN_LAST_4");
            Age = CDataUtils2.GetDSLongValue(ds, "PATIENT_AGE");

            
        }
    }
}
